TradeVehicles = {}

TradeVehicles.MOD_NAME = g_currentModName
TradeVehicles.MOD_DIR = g_currentModDirectory

if not g_modIsLoaded[TradeVehicles.MOD_NAME] then
    return
end






-- Handle Stats Menu

onButtonSell_OLD = InGameMenuStatisticsFrame.onButtonSell
InGameMenuStatisticsFrame.onButtonSell = Utils.overwrittenFunction(InGameMenuStatisticsFrame.onButtonSell, TradeVehicles.onButtonSell)
function InGameMenuStatisticsFrame:onButtonSell(p276)
    --print("onButtonSell p276:", p276)

    local frame = p276 or self
    if not frame.vehicles or not frame.vehiclesList then
        print("Error: Missing vehicles or vehicleList in frame.")
        return
    end

    local selectedVehicle  = frame.vehicles[frame.vehiclesList:getSelectedIndexInSection()]if selectedVehicle ~= nil and selectedVehicle.vehicle ~= nil then
        local vehicle = selectedVehicle.vehicle
        local item = g_storeManager:getItemByXMLFilename(vehicle.configFileName)

        -- Permission check
        if not g_currentMission:getHasPlayerPermission(Farm.PERMISSION.SELL_VEHICLE) then
            --print("Player does not have permission to sell vehicles.")

            TradeVehicles.notiDialog = g_gui:showDialog("InfoDialog")
            --p15.notiDialog.target:setText(g_i18n:getText("ui_loadingSavegame"))
            TradeVehicles.notiDialog.target:setText(g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_NO_PERM)
            TradeVehicles.notiDialog.target:setButtonTexts(g_i18n:getText("button_ok"))
            --TradeVehicles.notiDialog.target:setCallback(p15.onCancelSavegameLoading, p15)
            return
        end

        if not g_currentMission.missionDynamicInfo.isMultiplayer then
            print("Error: Trade vehicles only works in multiplayer.")
            g_shopController:sell(item, vehicle)
            return
        end

        local dialog = g_gui:showDialog("OptionDialog")
        local args = {
            text = g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_CHOOSE_ACTION,
            title = g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_SELL_OR_TRADE,
            options = {
                g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_SELL,
                g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_TRADE
            },
            args = {"sell", "trade"},
            callback = function(sel)
                if sel == 2 then
                    local farms = g_farmManager:getFarms(g_farmManager)
                    local farmList = {}
                    local farmIds = {}

                    for _, farm in ipairs(farms) do
                        --print("Farm", farm)
                        --print("Farm ID:", farm.farmId)
                        --print("Farm Name:", farm.name)

                        if farm ~= nil then
                            if farm.name ~= nil and farm.name ~= "" and farm.farmId ~= nil then
                                table.insert(farmList, farm.name)
                                table.insert(farmIds, farm.farmId)
                            end
                        end
                    end

                    local dialog = g_gui:showDialog("OptionDialog")
                    local args = {
                        text = g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_CHOOSE_ACTION,
                        title = g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_NEW_OWNER,
                        options = farmList,
                        args = {}, -- Changed this to empty
                        callback = function(selectedIndex)
                            if selectedIndex > 0 then
                                local farmId = farmIds[selectedIndex]
                                local farmName = farmList[selectedIndex]

                                if vehicle:getIsInUse() then
                                    --print("Vehicle is in use")
                                    TradeVehicles.notiDialog = g_gui:showDialog("InfoDialog")
                                    --p15.notiDialog.target:setText(g_i18n:getText("ui_loadingSavegame"))
                                    TradeVehicles.notiDialog.target:setText(g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_IN_USE)
                                    TradeVehicles.notiDialog.target:setButtonTexts(g_i18n:getText("button_ok"))
                                    --TradeVehicles.notiDialog.target:setCallback(p15.onCancelSavegameLoading, p15)
                                    return
                                end

                                if vehicle.setOwnerFarmId ~= nil then
                                    local rootVehicle = vehicle.rootVehicle
                                    if rootVehicle ~= nil and rootVehicle:getIsAIActive() then
                                        rootVehicle:stopCurrentAIJob(AIMessageSuccessStoppedByUser.new())
                                    end


                                    if g_server ~= nil then
                                        vehicle:setOwnerFarmId(farmId)
                                        --g_server:broadcastEvent(ChangeVehicleConfigEvent.new(vehicle, farmId), nil, nil, vehicle)
                                    else
                                        local vehicleId = tonumber(NetworkUtil.getObjectId(vehicle))
                                        local farmId = tonumber(farmId)

                                        --print("Vehicle ID", vehicleId)
                                        --print("farm ID", farmId)

                                        local serverEvent = SetVehicleOwnerEvent.new(vehicleId, farmId)
                                        g_client:getServerConnection():sendEvent(serverEvent)
                                    end

                                    g_messageCenter:publish(MessageType.VEHICLE_ADDED, vehicle)

                                    TradeVehicles.notiDialog = g_gui:showDialog("InfoDialog")
                                    --p15.notiDialog.target:setText(g_i18n:getText("ui_loadingSavegame"))
                                    TradeVehicles.notiDialog.target:setText(g_i18n.modEnvironments[TradeVehicles.MOD_NAME].texts.TradeVehicles_SEND .. " " .. farmName)
                                    TradeVehicles.notiDialog.target:setButtonTexts(g_i18n:getText("button_ok"))
                                    --TradeVehicles.notiDialog.target:setCallback(p15.onCancelSavegameLoading, p15)
                                    return
                                else
                                    print("Error: setOwnerFarmId method is not available for this vehicle.")
                                end
                            else
                                --Close menu
                            end
                        end
                    }

                    dialog.target:setText(args.text)
                    dialog.target:setTitle(args.title)
                    dialog.target:setOptions(args.options)
                    dialog.target:setCallback(args.callback, args.target, args.args)

                    dialog.target:setButtonTexts(args.okText)
                elseif sel == 1 then
                    g_shopController:sell(item, vehicle)
                else
                    --Close menu
                end
            end
        }
    
        dialog.target:setText(args.text)
        dialog.target:setTitle(args.title)
        dialog.target:setOptions(args.options)
        dialog.target:setCallback(args.callback, args.target, args.args)
        dialog.target:setButtonTexts(args.okText)
    else
        print("No vehicle Selected.")
    end
end





SetVehicleOwnerEvent = {}
SetVehicleOwnerEvent_mt = Class(SetVehicleOwnerEvent, Event)

InitEventClass(SetVehicleOwnerEvent, "SetVehicleOwnerEvent")

function SetVehicleOwnerEvent:emptyNew()
    return Event.new(SetVehicleOwnerEvent_mt)
end

function SetVehicleOwnerEvent.new(vehicleId, farmId)
    --print("Test vehicleid", vehicleId)
    --print("Test farmId", farmId)

    local self = SetVehicleOwnerEvent:emptyNew()
    self.vehicleId = vehicleId or nil
    self.farmId = farmId
    return self
end

function SetVehicleOwnerEvent:readStream(streamId, connection)
    self.vehicleId = streamReadInt32(streamId)
    self.farmId = streamReadInt32(streamId)
    self:run(connection)
end


function SetVehicleOwnerEvent:writeStream(streamId, connection)
    if self.vehicleId and self.farmId then
        streamWriteInt32(streamId, self.vehicleId)
        streamWriteInt32(streamId, self.farmId)
    else
        print("Error: Attempting to write invalid data to stream.")
    end
end

function SetVehicleOwnerEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, nil, connection)
    end

    --print("I Got farmId => ", self.farmId)
    --print("I Got vehicleId => ", self.vehicleId)

    local vehicle = NetworkUtil.getObject(self.vehicleId)
    if vehicle then
        vehicle:setOwnerFarmId(self.farmId)
        g_messageCenter:publish(MessageType.VEHICLE_ADDED, vehicle)
    else
        print("Error: Vehicle not found for ID", self.vehicleId)

        -- Retry logic
        g_currentMission:addDelayedCall(200, function()
            local retryVehicle = NetworkUtil.getObject(self.vehicleId)
            if retryVehicle then
                retryVehicle:setOwnerFarmId(self.farmId)
                g_messageCenter:publish(MessageType.VEHICLE_ADDED, retryVehicle)
                --print("Vehicle ownership successfully updated after retry.")
            else
                print("Error: Vehicle still not found after retry for ID", self.vehicleId)
            end
        end)
    end
end