--[[
Copyright (C) Achimobil

Author: Achimobil
Date: 08.07.2022
Version: 0.1.0.0

Contact:
https://discord.gg/Va7JNnEkcW

History:
V 0.1.0.0 @ 08.07.2022 - First Version.

Important:
Free for use in other mods - no permission needed, only provide my name.
No changes are to be made to this script without permission from Achimobil.

Frei verwendbar - keine erlaubnis nötig, Namensnennung im Mod erforderlich.
An diesem Skript dürfen ohne Genehmigung von Achimobil keine Änderungen vorgenommen werden.
]]

RealMultiFruitSiloSpecialization = {
    Version = "0.1.0.0",
    Name = "RealMultiFruitSiloSpecialization"
}
print(g_currentModName .. " - init " .. RealMultiFruitSiloSpecialization.Name .. "(Version: " .. RealMultiFruitSiloSpecialization.Version .. ")");

function RealMultiFruitSiloSpecialization.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(PlaceableSilo, specializations);
end

function RealMultiFruitSiloSpecialization.registerEventListeners(placeableType)
	SpecializationUtil.registerEventListener(placeableType, "onLoad", RealMultiFruitSiloSpecialization);
end

function RealMultiFruitSiloSpecialization:onLoad(savegame)
	local spec = self.spec_silo;

    for _, storage in ipairs(spec.storages) do
        local totalCapacity = 0;
        for fillType, accepted in pairs(storage.fillTypes) do
            if(accepted and storage.capacities[fillType] == nil) then
                storage.capacities[fillType] = storage.capacity;
            end
            if(storage.capacities[fillType] ~= nil) then
                totalCapacity = totalCapacity + storage.capacities[fillType];
            end
        end
        storage.capacity = totalCapacity;
    end
end